#include "nxp_lpc11u6x.h"

void SCT1_Init(void)
{
    LPC_SYSCON->PRESETCTRL  |= (1 << 10);              // de-assert SCT1 reset

    LPC_SCT1->CONFIG        |= (1 << 0) | (1 << 17);   // unified 32-bit timer, auto limit

    LPC_SCT1->MATCH[0].U     = SystemCoreClock/100;
    LPC_SCT1->MATCHREL[0].U  = SystemCoreClock/100;

    LPC_SCT1->EVENT[0].STATE = 0x00000001;             // event 0 only happens in state 0
    LPC_SCT1->EVENT[0].CTRL  = (0 << 0)  |             // MATCHSEL[3:0]   = related to match 0
                               (1 << 12) |             // COMBMODE[13:12] = match condition only
                               (0 << 14) |             // STATELD [14]    = STATEV is added to state
                               (0 << 15);              // STATEV  [15]    = no state change

    LPC_SCT1->EVEN           = (1 << 0);               // event 0 generates an interrupt
    NVIC_EnableIRQ(SCT0_1_IRQn);                       // enable SCT interrupt

    LPC_SCT1->CTRL_U        &= ~(1 << 2);              // unhalt it by clearing bit 2 of the CTRL register
}
